/*
 * Copyright (c) 2023 Afrel Co., Ltd. 
 * All rights reserved
 */
#include <stdlib.h>
#include <kernel.h>

#include <spike/hub/system.h>

#include <rxtest.h>

#include "spike/pup/motor.h"
#include "spike/pup/colorsensor.h"
#include "spike/pup/forcesensor.h"
#include "spike/pup/ultrasonicsensor.h"

#include "spike/hub/battery.h"
#include "spike/hub/button.h"
#include "spike/hub/display.h"
#include "spike/hub/imu.h"
#include "spike/hub/light.h"
#include "spike/hub/speaker.h"

#include <pbio/color.h>

pup_motor_t *motorA;             //モータAを使う変数
pup_motor_t *motorB;             //モータBを使う変数
pup_device_t *ColorSensor;       //カラーセンサーを使う変数
pup_device_t *ForceSensor;       //フォースセンサーを使う変数
pup_device_t *UltraSonicSensor;  //距離センサーを使う変数

#include <stdio.h>
#include <string.h>
#include <syssvc/serial.h>

void Main(intptr_t exinf)
{
  char tempstr[20]; // テンポラリ文字列
  char input[1];    // 受信データ
  T_SERIAL_RPOR pk_rpor;  // ポート状態の構造体
  ER ret;

  dly_tsk(3000000);  // 3秒待ちます

  // シリアルポートをオープン 115200 bps
  serial_opn_por(SIO_USART_F_PORTID);

  while(1){
    // シリアルポートの状態
    serial_ref_por(SIO_USART_F_PORTID, &pk_rpor);
    if(pk_rpor.reacnt > 0){ // 受信バッファを確認
      // シリアルポート受信
      ret = serial_rea_dat(SIO_USART_F_PORTID,
            input, sizeof(input));

      // 受信データをライトマトリクスに表示
      sprintf(tempstr,"%c",input[0]);
      hub_display_text(tempstr, 200, 200);
    }
    dly_tsk(1000);  // 1ミリ秒待ちます
  }
  //プログラムを終了します
  exit(0);
}
