/*
 * Copyright (c) 2023 Afrel Co., Ltd. 
 * All rights reserved
 */
#include <stdlib.h>
#include <kernel.h>

#include <spike/hub/system.h>

#include <test2.h>

#include "spike/pup/motor.h"
#include "spike/pup/colorsensor.h"
#include "spike/pup/forcesensor.h"
#include "spike/pup/ultrasonicsensor.h"

#include "spike/hub/battery.h"
#include "spike/hub/button.h"
#include "spike/hub/display.h"
#include "spike/hub/imu.h"
#include "spike/hub/light.h"
#include "spike/hub/speaker.h"

#include <pbio/color.h>

pup_motor_t *motorA;             //モータAを使う変数
pup_motor_t *motorB;             //モータBを使う変数
pup_device_t *ColorSensor;       //カラーセンサーを使う変数
pup_device_t *ForceSensor;       //フォースセンサーを使う変数
pup_device_t *UltraSonicSensor;  //距離センサーを使う変数

#include <stdio.h>
#include <string.h>
#include <syssvc/serial.h>

void Main(intptr_t exinf)
{
  SYSTIM st; // システム時刻の格納領域
  int32_t start_time,now_time;
  char tempstr[20]; // テンポラリ文字列
  int count;        // 送信回数

  dly_tsk(1000000);      //1秒待機
  serial_opn_por(SIO_USB_PORTID); // シリアルポート初期化

  count = 0;      // 送信回数
  get_tim(&st);   // システム時刻を取得
  now_time = (int32_t)st;
  while(1){
    sprintf(tempstr, "%d", count);
    serial_wri_dat(SIO_USB_PORTID, tempstr, strlen(tempstr)); // シリアル送信
    hub_display_text(tempstr, 200, 200);  // 文字表示(文字列,表示時間,消灯時間)
    start_time = now_time;
    while(1){
      get_tim(&st);   // システム時刻を取得
      now_time = (int32_t)st;
      if((now_time-start_time) >= 2000000)break; // 2秒待機
    }
    count++; // 送信回数+1
  }

  //プログラムを終了します
  exit(0);
}
