/*
 * Copyright (c) 2023 Afrel Co., Ltd. 
 * All rights reserved
 */
#include <stdlib.h>
#include <kernel.h>

#include <spike/hub/system.h>

#include <test.h>

#include "spike/pup/motor.h"
#include "spike/pup/colorsensor.h"
#include "spike/pup/forcesensor.h"
#include "spike/pup/ultrasonicsensor.h"

#include "spike/hub/battery.h"
#include "spike/hub/button.h"
#include "spike/hub/display.h"
#include "spike/hub/imu.h"
#include "spike/hub/light.h"
#include "spike/hub/speaker.h"

#include <pbio/color.h>

pup_motor_t *motorA;             //モータAを使う変数
pup_motor_t *motorB;             //モータBを使う変数
pup_device_t *ColorSensor;       //カラーセンサーを使う変数
pup_device_t *ForceSensor;       //フォースセンサーを使う変数
pup_device_t *UltraSonicSensor;  //距離センサーを使う変数

#include <math.h>
// sin/cos関数の実験
void Main(intptr_t exinf)
{
  hub_button_t button;
  uint8_t row,column,brightness;
  double degree,radian,r,speed;

  brightness = 100; // 明るさ
  r = 2.4;          // 半径
  degree = 0.0;     // 角度
  speed = 1.0;      // 角速度
  while(1){
    hub_button_is_pressed(&button);
    if(button & HUB_BUTTON_RIGHT)speed += 1.0;
    if(button & HUB_BUTTON_LEFT) speed -= 1.0;

    hub_display_off(); // ピクセルを消灯
    radian = 3.1415 * degree / 180.0; // 角度をラジアンに変換
    row    = (uint8_t)(sin(radian) * r + 2.5);  // 行を算出
    column = (uint8_t)(cos(radian) * r + 2.5);  // 列を算出
    hub_display_pixel(row, column, brightness); // ピクセルを点灯
    degree += speed;                            // 角度を加算
    if(degree >= 360.0) degree -= 360.0;
    if(degree <    0.0) degree += 360.0;
    dly_tsk(50000);     // 0.05秒待ちます
  }
  //プログラムを終了します
  exit(0);
}
